 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 18/11/2012
 *
 *******************************************************************/
 #include "Queue0.h"      // class Queue
 #include "message.h"    // class ExternalMessage, InternalMessage
 #include <iostream>
 #include <fstream>
 ofstream UQI0 ("UE0QIn.txt");
 ofstream UQO0 ("UE0QOut.txt");

 Queue0::Queue0( const string &name ) : Atomic( name )
 , In( addInputPort( "In" ) )
 , InCoMP1( addInputPort( "InCoMP1" ) )
 , InCoMP6( addInputPort( "InCoMP6" ) )
 , Req( addInputPort( "Req" ) )
 , Out( addInputPort( "Out" ) )
 , ProcessTime (00,00,00,00)
 {
 }

 Model &Queue0::initFunction()
 {
   Request = 0;
   Qlen = 0;
   state = Idle;
   elements.erase( elements.begin(), elements.end() ) ;
   passivate();
   return *this ;
 }

 Model &Queue0::externalFunction( const ExternalMessage &msg )
 { UQI0 <<msg.time()<<" "<<msg.value()<<"\n";
   if( msg.port() != Req ) // Input from In1 or In2 or In3
	 {
	   elements.push_back( msg.value() ) ; //Store Input value in Queue
	   state = Push;
	   Qlen++;
	   holdIn( Atomic::active, ProcessTime);
	 }
     else if (elements.size() > 0)  //So msg.port() == Req  ===> Pop from Queue (Check that the Queue is not empty)
          	 {
    	       Request = 1;
    	       state = Pop;
    	       holdIn( Atomic::active, ProcessTime);
      	     }
             else if (elements.size() == 0)
            	     {      // Here this two condition are True :(msg.port() == Req) & (elements.size() == 0)
            	       Request = 1;   // Although Queue is empty but remember that server is waiting for input.
            	       passivate();   // If the queue is empty then passivate.
            	     }
   return *this;
 }

 Model &Queue0::outputFunction( const InternalMessage &msg )
 {
   if ((state == Pop) && (Request == 1))
	  {
	     sendOutput( msg.time(), Out, elements.front());  // Send out data from Queue
	     UQO0 <<msg.time()<<" Out "<<elements.front()<<"\n";
	  }
   return *this ;
 }

 Model &Queue0::internalFunction( const InternalMessage & )
 {
   switch (state){
   				    case Idle:
   				    	       if (Request == 1) state = Pop;
   				    	         else passivate();
   					           break;

   				    case Push:
 			    	            state = Idle;
   					            break;

   				    case Pop:
   				    	       elements.pop_front();
   				    	       Qlen--;
   				    	       Request = 0;
   				    	       state = Idle;
   					           break;
           		 }
   return *this;
 }

 Queue0::~Queue0()
 {
 }
